#ifndef DBWTOOLS_H
#define DBWTOOLS_H

#include <lwpp/xpanel.h>

enum { CT_HOME = 0x9900, CT_LOGO};

/* version number for loading and saving */
#define DBWTOOLS_VERSION 1
/* version number of the product */
#define VERSION_NUMBER "1.1b"
#define RELEASE
//#define RELEASE_CANDIDATE

#define HOST_OS "(" LWPP_PLATFORM_NAME ")"

#ifndef _DEBUG
	#ifdef RELEASE_CANDIDATE
			#define DBWTOOLS_VERSION_STRING VERSION_NUMBER "-RC " HOST_OS 
	#else
	#ifdef RELEASE
			#define DBWTOOLS_VERSION_STRING VERSION_NUMBER " " HOST_OS	
		#else
			#define DBWTOOLS_VERSION_STRING VERSION_NUMBER " " HOST_OS " *beta*"
		#endif // RELEASE_CANDIDATE
	#endif // RELEASE
#else
	#define DBWTOOLS_VERSION_STRING VERSION_NUMBER " " HOST_OS " *debug*"
#endif // _DEBUG

#define PLUGIN_NAME "d&bw Tools"

#define PLUGIN_FULL_NAME PLUGIN_NAME " V" DBWTOOLS_VERSION_STRING
#define PLUGIN_SHORT_NAME "dbwTools" HOST_OS "_V" VERSION_NUMBER 

//void ClickURL(LWXPanelID, unsigned long);
extern LWXPanelHint dbwHint[];

#endif